import java.math.BigDecimal;
import java.util.concurrent.*;

class FactorialForkJoin {
	static public BigDecimal factorial(int argument, int threshold) {
		var task = new FactorialTask(1, argument, threshold);
		var pool = new ForkJoinPool();
		pool.invoke(task);
		pool.shutdown();
		return task.join();
	}
	
	static public BigDecimal factorial(int argument) {
		return factorial(argument, Runtime.getRuntime().availableProcessors() * 10);
	}

	private static class FactorialTask extends RecursiveTask<BigDecimal> {
		private final int start, end;
		private final int threshold;

		public FactorialTask(int start, int end, int threshold) {
			this.start = start;
			this.end = end;
			this.threshold = threshold;
		}

		private BigDecimal multiplyIt(int start, int end) {
			BigDecimal factorial = BigDecimal.valueOf(start);
			for (int i = start + 1; i <= end; i++)
				factorial = factorial.multiply(BigDecimal.valueOf(i));
			return factorial;
		}

		@Override
		protected BigDecimal compute() {
			BigDecimal factorial;
			int diff = end - start;
			if (diff <= threshold)
				factorial = multiplyIt(start, end);
			else {
				int half = diff / 2;
				var task1 = new FactorialTask(start, start + half, threshold);
				var task2 = new FactorialTask(start + half + 1, end, threshold);
				task2.fork();
				BigDecimal erg1 = task1.compute();
				BigDecimal erg2 = task2.join();
				factorial = erg1.multiply(erg2);
			}
			return factorial;
		}
	}
}